/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.core.util.EclipseUtil;
import com.aptana.js.debug.core.internal.model.JSDebugTarget;
import com.aptana.js.debug.core.internal.model.Messages;
import com.aptana.js.debug.core.internal.model.WatchExpressionResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class WatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        IDebugTarget target;
        IDebugTarget suspendResume = context.getDebugTarget();
        if (context instanceof ISuspendResume) {
            suspendResume = (ISuspendResume)context;
        }
        if (suspendResume.isSuspended() && (target = context.getDebugTarget()) instanceof JSDebugTarget) {
            EvaluationJob job = new EvaluationJob((JSDebugTarget)target, expression, context, listener);
            job.schedule();
            return;
        }
        listener.watchEvaluationFinished(null);
    }

    private final class EvaluationJob
    extends Job {
        private JSDebugTarget target;
        private String expression;
        private IDebugElement context;
        private IWatchExpressionListener listener;

        public EvaluationJob(JSDebugTarget target, String expression, IDebugElement context, IWatchExpressionListener listener) {
            super(Messages.WatchExpressionDelegate_ExpressionEvaluation);
            EclipseUtil.setSystemForJob((Job)this);
            this.target = target;
            this.expression = expression;
            this.context = context;
            this.listener = listener;
        }

        protected IStatus run(IProgressMonitor monitor) {
            WatchExpressionResult watchResult = null;
            try {
                Object result = this.target.evaluateExpression(this.expression, this.context);
                if (result instanceof IValue) {
                    watchResult = new WatchExpressionResult(this.expression, (IValue)result);
                } else if (result instanceof String[]) {
                    watchResult = new WatchExpressionResult(this.expression, null, (String[])result);
                }
            }
            catch (DebugException e) {
                watchResult = new WatchExpressionResult(this.expression, e, null);
            }
            this.listener.watchEvaluationFinished((IWatchExpressionResult)watchResult);
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)WatchExpressionDelegate.this, 2, 128)});
            return Status.OK_STATUS;
        }
    }
}

